% created by Nils Hase 2016 (nilshase@math.uni-bremen.de)

% function to provide colormap and linecolor (for borders) to a plot

function [my_colormap,linecolor] = get_colors()

% Linecolor for borders
linecolor = [0,0,0,0.2];

% Red for sinks 
cm_sinks = [[251,106,51]; 
            [252,187,161]];
% White for neutral
cm_neutral = [255,255,255];
% Yelloish/Greenish/blueish for sources
cm_sources = [[255,255,217];
              [246,251.5,197];
              [237,248,177];
              [218,  240.5,  178.5];
              [199,  233,  180];
              [163,  219,  183.5];
              [127,  205,  187];
              [96,  193.5,  191.5];
              [65,  182,  196];
              [47,  163.5,  194];
              [29,  145,  192];
              [31.5,  119.5,  180];
              [34,   94,  168];
              [35.5,   73,  158];
              [37,   52,  148];
              [22.5,   40.5,  118]];
cm_sources(:,3) = cm_sources(:,3) - 20*linspace(1,0,size(cm_sources,1))';
cm_sources = min(cm_sources,255*ones(size(cm_sources)))-10*linspace(1,0,size(cm_sources,1))'*ones(1,3);

my_colormap = [cm_sinks;cm_neutral;cm_sources]./255;

end
